close all 

%%%%%%%%%%%%%%%% Parameters
% %%%%% Loop through these
n_vec = [20 30 40 ]; %graph size
N_vec = [4 6 7]; %subset size

%%%%% Other parameters
alpha = 0.2;  %null parameter, edge density under alternative
kappa = 0.1;  %target level
num_a_samples = 16; %number of sample points on horizontal axis

%%%%% don't change below (important for accuracy)
M_calibration = 75; % number of calibration samples
M_power = 200; %number of power reps 
B_vec = [1];

%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% Make threshold array
threshold_array = zeros(length(n_vec), length(N_vec),length(B_vec));

%%%%% Time estimate (in minutes) , TO DO: update this
Total_time_estimate = 0;
gamma = 0.13e-03; %% conversion factor (time per loop per # subsets)

for n_vec_idx = 1:length(n_vec)
    for N_vec_idx = 1:length(N_vec)
        n = n_vec(n_vec_idx);
        N = N_vec(N_vec_idx);
        Total_time_estimate = Total_time_estimate + gamma*nchoosek(n, N); 
    end
end

Total_time_estimate/3600

%%%time estimate
time_trial = zeros(length(N_vec), 1);

%%%%% Main script 
for n_vec_idx = 1:length(n_vec)
    for N_vec_idx = 1:length(N_vec)
        for B_vec_idx = 1:length(B_vec)

            %%time estimate
            tic

            n = n_vec(n_vec_idx);
            N = N_vec(N_vec_idx);
            B = B_vec(B_vec_idx); 

            %%% calibrate scan stat (set threshold) (most time-consuming
            %%% part)
            threshold = true_calibrate_scan(n, N, alpha, B, M_calibration, kappa);
            threshold_array(n_vec_idx, N_vec_idx, B_vec_idx) = threshold;

            %%%%%%% compute power
            %range of a for given alpha 
            a_max = min(alpha*n/N, 1);  
            a_vec = linspace(alpha, a_max, num_a_samples); 
            
%           a_vec = linspace(alpha, alpha, num_a_samples); %use this to debug t1 error 

            [oracle_scan_power_vec , SgnQ_power_vec]...
    = oracle_power_scan( n, N, alpha, B, M_power, kappa, threshold, num_a_samples );

            %%%%%%%%%% compute stat and comp thresholds 

            c_vec = (alpha*n^2 - 2*alpha*n*N + N^2.*a_vec)/(n - N)^2;

            stat_pt_values = (1/2)*sqrt(N).*(a_vec - c_vec)./sqrt(c_vec.*(1 - c_vec) );
            comp_pt_values = N.*(a_vec - c_vec)./sqrt(n.*c_vec);

            %         figure
            %         hold on
            %         plot(a_vec, stat_pt_values)
            %         plot(a_vec, comp_pt_values)

            stat_pt = a_vec(min(find(stat_pt_values > 1 )));
            comp_pt = a_vec(min(find(comp_pt_values > 1 )));

            if isempty(stat_pt) == 1
                stat_pt = a_max;    
            end

            if isempty(comp_pt) == 1
                comp_pt = a_max;     
            end

            stat_pt_vert_line = stat_pt.*ones(length(0:0.5:1),1)';
            comp_pt_vert_line = comp_pt.*ones(length(0:0.5:1),1)';

            %%%%%%% Plot power and thresholds
            figure
            hold on
            plot( a_vec, oracle_scan_power_vec, 'black', LineWidth=2 ) 
            plot( a_vec, SgnQ_power_vec, 'blue', LineWidth=2 )
            plot(stat_pt_vert_line, 0:0.5:1, 'black', 'LineWidth', 2,'LineStyle','-.' );
            plot(comp_pt_vert_line, 0:0.5:1, 'blue', 'LineWidth', 2,'LineStyle','--');
            xlabel('a', 'FontSize', 14)
            ylabel('Power', 'FontSize', 14)
            title_info = sprintf('Power of oracle scan vs. SgnQ: N = %d , n = %d ', N, n);
            file_info_png = sprintf('Plots/Oracle_Scan_vs_SgnQ_N = %d_n = %d_alpha = %.2f.png', N, n,  alpha );
            file_info_fig = sprintf('Plots/Oracle_Scan_vs_SgnQ_N = %d_n = %d_alpha = %.2f.fig', N, n, alpha );
            title(title_info, 'FontSize', 14);
            legend('scan', 'SgnQ');
            %%%%%%% Save figure 
            saveas(gcf, file_info_png);
            saveas(gcf, file_info_fig);

%%time estimate
            time_trial(N_vec_idx) = toc;

        end
    end
end

%%%%%%%%%%%%%time estimate validation
subset_sizes = zeros(length(N_vec), 1);

for i = 1:length(N_vec)
    subset_sizes(i) = nchoosek(n_vec(1), N_vec(i));
end

% plot( subset_sizes , time_trial)
time_trial./subset_sizes
%%%%%%%%%%%%%

%%%% Save thresholds in table
threshold_tab = [n_vec', threshold_array];
threshold_tab = [[0, N_vec]; threshold_tab ];
T = table(threshold_tab);
n_vec_info = sprintf('%d,', n_vec(:));
N_vec_info = sprintf('%d,', N_vec(:));
table_info = sprintf('/Table/Oracle,n_vec=%sN_vec=%salpha=%.2f.txt', n_vec_info, N_vec_info, alpha);
writetable(T, [pwd table_info])


